﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class DesktopProcess : UserControl,IControl,ICorrespondenceOS
    {
        private DesktopProcessController desktopProcessController;

        public DesktopProcess()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,                                             
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetDesktopProcessState(bool b)
        {
            checkBox1.Checked = b;
        }


        public int GetDesktopProcessState()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            desktopProcessController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return desktopProcessController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void DesktopProcess_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            desktopProcessController = new DesktopProcessController(this,
                                                                        (IDesktopProcessStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new DesktopProcessDefaultStrategy()
                                                                                 }));
            desktopProcessController.Read();
        }
    }
}
